<?php
/**
 * Advanced CRON Scheduler for Onnac GMB SAAS
 * Cron Command Example: * * * * * /usr/bin/php /path/to/scheduler.php
 */

require_once __DIR__ . '/database.php';
require_once __DIR__ . '/api_functions.php';

echo "Starting Scheduled Posts CRON Job...\n";

// Get all pending posts where schedule_time is in the past
$stmt = $db->query("SELECT p.*, u.refresh_token, u.account_id, u.location_id 
                    FROM scheduled_posts p 
                    JOIN users u ON p.user_email = u.email 
                    WHERE p.status = 'pending' AND p.schedule_time <= datetime('now', 'localtime')");
$posts = $stmt->fetchAll();

foreach ($posts as $post) {
    echo "Processing Post ID: {$post['id']} for User: {$post['user_email']} \n";

    // Refresh User Token
    $access_token = refreshAccessToken($post['refresh_token']);
    if (!$access_token) {
        echo " > Failed to refresh token. Marking as failed.\n";
        $db->prepare("UPDATE scheduled_posts SET status = 'failed' WHERE id = ?")->execute([$post['id']]);
        continue;
    }

    // Prepare Post Payload
    $post_data = ["topicType" => $post['post_type'], "summary" => $post['content']];

    if ($post['post_type'] === 'EVENT') {
        $post_data['event'] = [
            "title" => "Special Event",
            "schedule" => [
                "startDate" => ["year" => date('Y'), "month" => date('m'), "day" => date('d')],
                "startTime" => ["hours" => date('H'), "minutes" => date('i')],
                "endDate" => ["year" => date('Y'), "month" => date('m'), "day" => date('d') + 1],
                "endTime" => ["hours" => 23, "minutes" => 59]
            ]
        ];
    }

    if (!empty($post['media_url'])) {
        $post_data["media"] = [
            ["mediaFormat" => "PHOTO", "sourceUrl" => $post['media_url']]
        ];
    }

    // Try Publishing
    $res = postToGMB($access_token, $post['account_id'], $post['location_id'], $post_data);

    if ($res['status']) {
        echo " > Successfully posted. \n";
        $db->prepare("UPDATE scheduled_posts SET status = 'published' WHERE id = ?")->execute([$post['id']]);
    } else {
        echo " > Error posting: " . print_r($res['response'], true) . "\n";
        $db->prepare("UPDATE scheduled_posts SET status = 'failed' WHERE id = ?")->execute([$post['id']]);
    }

    sleep(1); // Anti-spam delay between requests
}

echo "Scheduler Job Completed.\n";
?>