<?php
require_once 'config.php';

try {
    // Ye SQLite file automatically create ho jayegi
    $db = new PDO('sqlite:' . DB_FILE);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // 1. Users Table
    $db->exec("CREATE TABLE IF NOT EXISTS users (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        email TEXT UNIQUE NOT NULL,
        refresh_token TEXT NOT NULL,
        account_id TEXT,
        location_id TEXT
    )");

    // Attempt to add location_name safely if it doesn't already exist
    try {
        $db->exec("ALTER TABLE users ADD COLUMN location_name TEXT");
    } catch (PDOException $e) {
        // Column likely already exists, ignore
    }

    // 2. Scheduled Posts Table (Content Calendar and Scheduler ke liye)
    $db->exec("CREATE TABLE IF NOT EXISTS scheduled_posts (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        user_email TEXT NOT NULL,
        post_type TEXT NOT NULL,
        content TEXT NOT NULL,
        media_url TEXT,
        schedule_time DATETIME NOT NULL,
        status TEXT DEFAULT 'pending'
    )");

} catch (PDOException $e) {
    die("Database Connection Error: Aapke server par SQLite enabled nahi hai. Kripya enable karein. Error: " . $e->getMessage());
}
?>