<?php
require_once 'database.php';

if (!isset($_GET['code'])) {
    die("Error: No authorization code provided.");
}

$code = $_GET['code'];

// 1. Exchange code for access & refresh tokens
$ch = curl_init('https://oauth2.googleapis.com/token');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
    'client_id' => CLIENT_ID,
    'client_secret' => CLIENT_SECRET,
    'code' => $code,
    'grant_type' => 'authorization_code',
    'redirect_uri' => REDIRECT_URI
]));
$response = curl_exec($ch);
curl_close($ch);

$token_data = json_decode($response, true);

if (isset($token_data['error'])) {
    die("Error exchanging token: " . htmlspecialchars($token_data['error']));
}

$access_token = $token_data['access_token'];
// Refresh token is only returned on first authorization or with prompt=consent
$refresh_token = $token_data['refresh_token'] ?? null;

// 2. Get user email
$ch = curl_init('https://www.googleapis.com/oauth2/v2/userinfo');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer $access_token"]);
$response = curl_exec($ch);
curl_close($ch);

$user_info = json_decode($response, true);
$email = $user_info['email'];

// 3. Get GMB Accounts
$ch = curl_init('https://mybusinessaccountmanagement.googleapis.com/v1/accounts');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer $access_token"]);
$response = curl_exec($ch);
curl_close($ch);

$accounts_data = json_decode($response, true);
$account_id = null;
$gmb_error = ""; // to track errors during GMB api calls

if (isset($accounts_data['error'])) {
    $gmb_error .= " Accounts API Error: " . json_encode($accounts_data['error']);
} elseif (!empty($accounts_data['accounts'])) {
    // The format is "accounts/{accountId}"
    $account_name = $accounts_data['accounts'][0]['name'];
    $account_parts = explode('/', $account_name);
    if (isset($account_parts[1])) {
        $account_id = $account_parts[1];
    }
} else {
    $gmb_error .= " No Accounts found for this email. ";
}

$location_id = null;
$location_name_str = null;
if ($account_id) {
    // 4. Fetch Locations for that account using Business Information API
    $ch = curl_init("https://mybusinessbusinessinformation.googleapis.com/v1/accounts/$account_id/locations?readMask=name,title");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer $access_token"]);
    $response = curl_exec($ch);
    curl_close($ch);

    $locations_data = json_decode($response, true);
    if (isset($locations_data['error'])) {
        $gmb_error .= " Locations API Error: " . json_encode($locations_data['error']);
    } elseif (!empty($locations_data['locations'])) {
        // The format is "accounts/{accountId}/locations/{locationId}"
        $location_name = $locations_data['locations'][0]['name'];
        $location_parts = explode('/', $location_name);
        if (isset($location_parts[3])) {
            $location_id = $location_parts[3];
            $location_name_str = $locations_data['locations'][0]['title'] ?? 'Unknown Location';
        }
    } else {
        $gmb_error .= " No Locations found for this account. ";
    }
} else {
    $gmb_error .= " Could not fetch locations because Account ID is missing. ";
}

// 5. Check if user already exists
$stmt = $db->prepare("SELECT * FROM users WHERE email = ?");
$stmt->execute([$email]);
$user = $stmt->fetch();

if ($user) {
    // Update details, preserve existing refresh token if Google didn't return a new one this time
    if ($refresh_token) {
        $stmt = $db->prepare("UPDATE users SET refresh_token = ?, account_id = ?, location_id = ?, location_name = ? WHERE email = ?");
        $stmt->execute([$refresh_token, $account_id, $location_id, $location_name_str, $email]);
    } else {
        $stmt = $db->prepare("UPDATE users SET account_id = ?, location_id = ?, location_name = ? WHERE email = ?");
        $stmt->execute([$account_id, $location_id, $location_name_str, $email]);
    }
} else {
    // Insert new user
    $stmt = $db->prepare("INSERT INTO users (email, refresh_token, account_id, location_id, location_name) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$email, $refresh_token ?? '', $account_id, $location_id, $location_name_str]);
}

$_SESSION['email'] = $email;
$_SESSION['gmb_debug'] = $gmb_error;

// Redirect to dashboard
header('Location: index.php');
exit;
?>