<?php
require_once 'database.php';

function refreshAccessToken($refresh_token)
{
    if (!$refresh_token)
        return false;
    $ch = curl_init('https://oauth2.googleapis.com/token');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'client_id' => CLIENT_ID,
        'client_secret' => CLIENT_SECRET,
        'refresh_token' => $refresh_token,
        'grant_type' => 'refresh_token'
    ]));
    $response = curl_exec($ch);
    curl_close($ch);

    $token_data = json_decode($response, true);
    return $token_data['access_token'] ?? false;
}

function fetchGmbReviews($access_token, $account_id, $location_id)
{
    // Note: mybusiness.googleapis.com is sometimes mapped differently, using v4 endpoint
    $url = "https://mybusiness.googleapis.com/v4/accounts/$account_id/locations/$location_id/reviews";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer $access_token"]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

function replyToReview($access_token, $account_id, $location_id, $review_id, $reply_text)
{
    $url = "https://mybusiness.googleapis.com/v4/accounts/$account_id/locations/$location_id/reviews/$review_id/reply";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['comment' => $reply_text]));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $access_token",
        "Content-Type: application/json"
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

function fetchGmbInsights($access_token, $account_id, $location_id)
{
    // Using BasicInsights endpoint from v4 or basic performance API. Basic v4 endpoint:
    $url = "https://mybusiness.googleapis.com/v4/accounts/$account_id/locations:reportInsights";
    $payload = [
        "locationNames" => ["accounts/$account_id/locations/$location_id"],
        "basicRequest" => [
            "metricRequests" => [
                ["metric" => "QUERIES_DIRECT"],
                ["metric" => "QUERIES_INDIRECT"],
                ["metric" => "VIEWS_MAPS"],
                ["metric" => "VIEWS_SEARCH"],
                ["metric" => "ACTIONS_WEBSITE"],
                ["metric" => "ACTIONS_PHONE"]
            ],
            "timeRange" => [
                "startTime" => date('Y-m-d\TH:i:s\Z', strtotime('-30 days')),
                "endTime" => date('Y-m-d\TH:i:s\Z')
            ]
        ]
    ];
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $access_token",
        "Content-Type: application/json"
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

function postToGMB($access_token, $account_id, $location_id, $post_data)
{
    $url = "https://mybusiness.googleapis.com/v4/accounts/$account_id/locations/$location_id/localPosts";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $access_token",
        "Content-Type: application/json"
    ]);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ['status' => $http_code == 200, 'response' => $response];
}

function getGmbAccounts($access_token)
{
    $ch = curl_init('https://mybusinessaccountmanagement.googleapis.com/v1/accounts');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer $access_token"]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

function getGmbLocations($access_token, $account_id)
{
    $url = "https://mybusinessbusinessinformation.googleapis.com/v1/accounts/$account_id/locations?readMask=name,title";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer $access_token"]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}
?>